<x-filament-panels::page :record="$record">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <p><strong>Serial Number:</strong> {{ $record->serial_number }}</p>
        </div>

        <div style="margin-top: 20px;">
            <div id="widget" wire:ignore></div>

            <div id="map" style="height: 400px; width: 100%; margin-top: 20px;" class="rounded-lg shadow" wire:ignore></div>

            <div style="margin-top: 20px;">
                <form wire:submit.prevent="submit">
                    <div style="margin-top: 20px;">
                        {{-- This still uses the Filament form rendering for the fields themselves --}}
                        {{ $this->form }}
                    </div>

                    {{-- Add the submit button here using the Filament button component --}}
                    <div style="margin-top: 20px;">
                        <x-filament::button
                            type="submit"
                            color="primary"
                        >
                            Save Changes
                        </x-filament::button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Google Maps JS: be sure to set key in config/services.php as google_maps.key --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.key') }}&libraries=places&callback=initMap" async defer></script>

    <script>
        let map;
        let autocomplete;
        let marker;

        function initMap() {
            const defaultCenter = { lat: Number("24.8607"), lng: Number("67.0011") };

            map = new google.maps.Map(document.getElementById('map'), {
                center: defaultCenter,
                zoom: 12,
            });

            const placeAutocomplete = new google.maps.places.PlaceAutocompleteElement({});
            document.getElementById('widget').appendChild(placeAutocomplete);


            placeAutocomplete.addEventListener('gmp-select', async ({placePrediction}) => {
                const place = placePrediction.toPlace();
                await place.fetchFields({ fields: ['location', 'addressComponents', 'formattedAddress', 'displayName'] });
                const placeData = place.toJSON();
                console.log(placeData);

                const lat = placeData.location.lat;
                const lng = placeData.location.lng;

                if (!marker) {
                    marker = new google.maps.Marker({
                        position: { lat, lng },
                        map: map,
                    });
                } else {
                    marker.setPosition({ lat, lng });
                }

                map.setCenter({ lat, lng });
                map.setZoom(17);

                const businessName = placeData.displayName+" "+placeData.formattedAddress;
                const placeId = placePrediction.placeId;
                const reviewUrl = `https://search.google.com/local/writereview?placeid=${placeId}`;
                @this.set('data.business_name', businessName);
                @this.set('data.review_url', reviewUrl);
            });
        }
    </script>
</x-filament-panels::page>
