<?php

namespace Database\Seeders;

use App\Enums\SystemRole;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            "List Users",
            "Create User",
            "Edit User",
            "Delete User"
        ];

        foreach ($permissions as $permission) {
            Permission::query()->firstOrCreate(['name' => $permission]);
        }

        $superAdmin = Role::query()->firstOrCreate(['name' => SystemRole::SUPER_ADMIN]);
        Role::query()->firstOrCreate(['name' => SystemRole::User, 'guard_name' => 'app']);
        $superAdmin->syncPermissions(Permission::all());
    }
}
