<?php

namespace Database\Seeders;

use App\Enums\SystemRole;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call(PermissionSeeder::class);

        $adminUser = Model::withoutEvents(function (){
            return User::factory()->create([
                'name' => 'Super Admin',
                'email' => 'admin@review.test',
                'is_active' => true
            ]);
        });

        $role = Role::query()->where('name', SystemRole::SUPER_ADMIN)->first();

        $adminUser->assignRole($role);
    }
}
