<?php

namespace App\Providers\Filament\Login;

use App\Enums\SystemRole;
use App\Models\User;
use Filament\Auth\Pages\Login;

class UserLogin extends Login
{
    protected function getCredentialsFromFormData(array $data): array
    {
        $user = User::query()->where('email', $data['email'])->first();

        if ($user && $user->roles()->where('name', '=', SystemRole::User)->exists()) {
            return [
                'email' => $data['email'],
                'password' => $data['password'],
            ];
        }

        return [
        ];
    }
}
